/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    public static String getMd5(File path) {
        try {
            return String.format("%032x", new BigInteger(1, MessageDigest.getInstance("MD5").digest(Files.readAllBytes(path.toPath())))).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMd5(InputStream is) {
        try {
            return String.format("%032x", new BigInteger(1, new DigestInputStream(is, MessageDigest.getInstance("MD5")).getMessageDigest().digest())).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean checkMD5(File file, String md5sum) throws IOException {
        int read;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("[ERROR] MD5 algorithm not found");
            return false;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[1024];
        while ((read = fis.read(data)) != -1) {
            digest.update(data, 0, read);
        }
        fis.close();
        byte[] md5sumBytes = MD5.fromHexString(md5sum);
        byte[] bytes = digest.digest();
        for (int i = 0; i < md5sumBytes.length; ++i) {
            if (md5sumBytes[i] == bytes[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] fromHexString(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static byte[] createChecksum(String filename) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static byte[] createChecksum(InputStream fis) throws Exception {
        int numRead;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return complete.digest();
    }

    public static String getMD5Checksum(String filename) {
        try {
            byte[] b = MD5.createChecksum(filename);
            Object result = "";
            for (int i = 0; i < b.length; ++i) {
                result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMD5Checksum(InputStream fis) throws Exception {
        byte[] b = MD5.createChecksum(fis);
        Object result = "";
        for (int i = 0; i < b.length; ++i) {
            result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

